var VARIABLE_BOOLEAN = 0;
var VARIABLE_NUMBER = 1;
var VARIABLE_STRING = 2;
var VARIABLE_LIST = 3;
var VARIABLE_PRODUCT = 4;
var VARIABLE_CALCULATION = 5;

var GEOMETRY_NONE = 0;
var GEOMETRY_LINE = 1;
var GEOMETRY_POLYGON = 2;
var GEOMETRY_PARALLELOGRAM = 3;
var GEOMETRY_CONTOURS = 4;
var GEOMETRY_POINT = 5;

var TYPE_SINGLE = 0;
var TYPE_CATEGORY = 1;

var TEMPLATE = [];
var PRODUCT = [];
var LAYER = [];
var VIEW = [];

var TEMPLATE_SYNC = "";
var PRODUCT_SYNC = "";
var NEW_SYNC = false;


function copyList(x)
{
    return x.slice(0, x.length);
}


function makeMenu(x)
{
    var HTML = "";

    for (var i = 0; i < x.length; i++)
    {
        HTML = HTML + '<option>' + x[i] + '</option>';
    }

    return HTML;
}


function toHex2(x)
{
    if (x > 255)
    {
        return "ff";
    }
    else if (x < 0)
    {
        return "00";
    }

    var digit = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"];

    var a1 = Math.floor(x / 16);
    var a2 = Math.floor(x % 16);

    return digit[a1] + digit[a2];
}


function indexOf(theList, x)
{
    for (var i = 0; i < theList.length; i++)
    {
        if (theList[i] == x)
        {
            return i;
        }
    }

    return -1;
}


function saveList(x, separator)
{
    var y = "";

    for (var i = 0; i < x.length; i++)
    {
        y = y + x[i];

        if (i < x.length - 1)
        {
            y = y + separator;
        }
    }

    return y;
}


function fitLength(x, y)
{
    var s = "" + x;

    while (s.length < y)
    {
        s = "0" + s;
    }

    return s;
}


function isNumber(x)
{
    var spaces = 0;

    for (var i = 0; i < x.length; i++)
    {
        var c = x.charCodeAt(i);

        if (!(c == 0x20 || c == 0x2c || c == 0x2d || c == 0x2e || (c >= 0x30 && c <= 0x39)))
        {
            return false;
        }

        if (c <= 0x20)
        {
            spaces = spaces + 1;
        }
    }

    if (spaces == x.length)
    {
        return false;
    }

    return true;
}


function formatString(x)
{
    // Temporary, still need to fix this function
    return x;

    var y = "";

    for (var i = 0; i < x.length; i++)
    {
        if (x.charAt(i) == '"')
        {
            y = y + "%22";
        }
        else
        {
            y = y + x.charAt(i);
        }
    }

    return y;
}


function currentTimeStamp()
{
    var d = new Date();

    return timeStamp(d.getUTCMonth()+1, d.getUTCDate(), d.getUTCFullYear(), d.getUTCHours(), d.getUTCMinutes());
}


function timeStamp(month, day, year, hour, minute)
{
    var y = "";

    y = y + fitLength(year, 4);
    y = y + fitLength(month, 2);
    y = y + fitLength(day, 2);
    y = y + "T"
    y = y + fitLength(hour, 2);
    y = y + fitLength(minute, 2);
    y = y + "Z";

    return y;
}


function currentTimeIndex()
{
    return timeIndex(currentTimeStamp());
}


function timeIndex(stamp)
{
    var y = parseInt(stamp.slice(0, 8) + stamp.slice(9, 13));

    return y;
}


function timeData(stamp)
{
    var y = {year: parseInt(stamp.slice(0, 4)), month: parseInt(stamp.slice(4, 6)), day: parseInt(stamp.slice(6, 8)), hour: parseInt(stamp.slice(9, 11)), minute: parseInt(stamp.slice(11, 13))}

    return y;
}


function formatTime(minutes)
{
    if (minutes < 0)
    {
        return "N/A";
    }
    else if (minutes == 0)
    {
        return "now";
    }
    else
    {
        if (minutes >= 60)
        {
            var hours = Math.floor(minutes / 60);

            minutes = minutes % 60;

            return (hours + "h" + " " + minutes + "m");
        }
        else
        {
            return (minutes + "m");
        }
    }
}


function isNumeric(x)
{
    var spaces = 0;

    for (var i = 0; i < x.length; i++)
    {
        var c = x.charCodeAt(i);

        if (!(c == 0x20 || c == 0x2c || c == 0x2d || c == 0x2e || (c >= 0x30 && c <= 0x39)))
        {
            return false;
        }

        if (c <= 0x20)
        {
            spaces = spaces + 1;
        }
    }

    if (spaces == x.length)
    {
        return false;
    }

    return true;
}


function stopsFromInterval(start, end, interval, unit)
{
    var s0 = start.getTime();
    var s1 = end.getTime();

    var y = [];
    var s = s0;

    var delta = 1;

    if (unit == "centuries")
    {
        delta = interval * 100*365.25*86400*1000;
    }
    else if (unit == "decades")
    {
        delta = interval * 10*365.25*86400*1000;
    }
    else if (unit == "years")
    {
        delta = interval * 365.25*86400*1000;
    }
    else if (unit == "months")
    {
        delta = interval * 30*86400*1000;
    }
    else if (unit == "weeks")
    {
        delta = interval * 7*86400*1000;
    }
    else if (unit == "days")
    {
        delta = interval * 86400*1000;
    }
    else if (unit == "hours")
    {
        delta = interval * 3600*1000;
    }
    else if (unit == "minutes")
    {
        delta = interval * 60*1000;
    }
    else if (unit == "seconds")
    {
        delta = interval * 1000;
    }
    else if (unit == "milliseconds")
    {
        delta = interval * 1;
    }

    while (s <= s1 + delta)
    {
        var d = new Date();
        d.setTime(s);
        y.push(d);

        s = s + delta;
    }

    return y;
}


function View(longitude, latitude, zoom)
{
    this.longitude = longitude;
    this.latitude = latitude;
    this.zoom = zoom;

    this.extentWest = 0;
    this.extentEast = 0;
    this.extentSouth = 0;
    this.extentNorth = 0;
    this.converted = true;

    this.save = function()
    {
        var y = this.longitude + ';' + this.latitude + ';' + this.zoom + ';' + this.extentWest + ';' + this.extentEast + ';' + this.extentSouth + ';' + this.extentNorth;

        return y;
    }
}


function Contour()
{
    this.value = null;
    this.points = [];
    this.closed = false;

    this.export = function()
    {
        var y = '{"value": "' + this.value + '", "points": "' + this.points + '", "closed": '+this.closed+'}';

        return y;
    }

    this.URL = function()
    {
        var y = '{\\"value\\": \\"' + this.value + '\\", \\"points\\": \\"' + this.points + '\\", \\"closed\\": '+this.closed+'}';

        return y;
    }

    this.saveString = function()
    {
        var y = '{value: ' + this.value + ', points: ' + this.points + ', closed: '+this.closed+'}';

        return y;
    }

    this.JSON = function()
    {
        var y = '{"value": "' + this.value + '", "points": [';

        for (var i = 0; i < this.points.length; i++)
        {
            y = y + '[' + this.points[i][0] + ', ' + this.points[i][1] + '], ';
        }

        y = y.slice(0, y.length-2) + '], "closed": '+this.closed+'}, ';

        return y;
    }

    this.XML = function()
    {
        var y = '    <contour>' + '\n';

        y = y + '      <value>' + this.value + '</value>' + '\n';
        y = y + '      <closed>' + this.closed + '</closed>' + '\n';

        y = y + '      <coordinate>' + '\n';

        for (var i = 0; i < this.points.length; i++)
        {
            y = y + '        <longitude>' + this.points[i][0] + '</longitude>' + '<latitude>' + this.points[i][1] + '</latitude>' + '\n';
        }

        y = y + '      </coordinate>' + '\n';

        y = y + '    </contour>' + '\n';

        return y;
    }
}


function Variable()
{
    this.name = "";
    this.type = VARIABLE_NUMBER;
    this.value = [];
    this.filter = [];
    this.product = [];

    this.copy = function()
    {
        var v = new Variable();

        v.name = this.name;
        v.type = this.type;
        v.value = copyList(this.value);
        v.filter = copyList(this.filter);

        return v;
    }

    this.save = function()
    {
        var y = this.name + '|' + this.type + '|' + saveList(this.value, "%3a") + '|' + saveList(this.filter, "%3a") + '|';

        return y;
    }
}


function Category()
{
    this.name = "";
    this.color = null;

    this.save = function()
    {
        var y = this.name + '|' + this.color + '|';

        return y;
    }
}


function Template()
{
    this.myIndex = 0;
    this.name = "";
    this.geometry = GEOMETRY_NONE;
    this.type = TYPE_SINGLE;
    this.category = [];
    this.variable = [];
    this.URL = "";
    this.text = "";
    this.expire = "";
    this.duration = 0;

    this.edit = false;
    this.exists = 1;
    this.canEdit = true;

    this.save = function()
    {
        var outString = "";

        outString = outString + this.name + ';' + this.geometry + ';' + this.type + ';';

        for (var i = 0; i < this.category.length; i++)
        {
            outString = outString + this.category[i].save();
        }

        if (this.category.length > 0)
        {
            outString = outString.slice(0, outString.length-1);
        }

        outString = outString + ';';

        for (var i = 0; i < this.variable.length; i++)
        {
            outString = outString + this.variable[i].save();
        }

        if (this.variable.length > 0)
        {
            outString = outString.slice(0, outString.length-1);
        }

        outString = outString + ';';

        outString = outString + this.URL + ';' + this.text + ';' + this.expire + ';' + this.duration + ';';

        return outString;
    }
}


function Product(base)
{
    this.myIndex = 0;
    this.templateIndex = 0;
    this.ID = 0;
    this.name = "";
    this.base = base;
    this.category = "";
    this.point = [];
    this.variable = [];
    this.issued = "";
    this.expire = "";
    this.text = base.text;
    this.forecaster = "";

    this.active = true;
    this.expired = false;
    this.opacity = 100;
    this.password = "";
    this.redraw = true;
    this.hidden = false;

    this.central = false;
    this.show = true;

    for (var i = 0; i < base.variable.length; i++)
    {
        this.variable.push(null);
    }

    this.renderText = function()
    {
        for (var i = 0; i < this.variable.length; i++)
        {
            varKey = "${" + this.variable[i].name + "}";

            this.text = this.text.replace(varKey, this.variable[i].value);
        }
    }

    this.exportText = function()
    {
        var y = "";

        for (var i = 0; i < this.text.length; i++)
        {
            if (this.text.charAt(i) == '\n')
            {
                y = y + "\\n";
            }
            else if (this.text.charAt(i) == '"')
            {
                y = y + '\\"';
            }
            else
            {
                y = y + this.text.charAt(i);
            }
        }

        return y;
    }

    this.timeSince = function()
    {
        var stampNow = currentTimeStamp();
        var timeNow = currentTimeIndex();
        var issuedIndex = timeIndex(this.issued);

        if (timeNow < issuedIndex)
        {
            return -1;
        }
        else
        {
            var nowData = timeData(stampNow);
            var issuedData = timeData(this.issued);

            var nowDate = new Date();
            var issuedDate = new Date();

            nowDate.setUTCMinutes(nowData.minute);
            nowDate.setUTCHours(nowData.hour);
            nowDate.setUTCDate(nowData.day);
            nowDate.setUTCMonth(nowData.month);
            nowDate.setUTCFullYear(nowData.year);

            issuedDate.setUTCMinutes(issuedData.minute);
            issuedDate.setUTCHours(issuedData.hour);
            issuedDate.setUTCDate(issuedData.day);
            issuedDate.setUTCMonth(issuedData.month);
            issuedDate.setUTCFullYear(issuedData.year);

            var delta = (nowDate.getTime() - issuedDate.getTime()) / 60000;

            return Math.round(delta);
        }
    }

    this.timeRemaining = function()
    {
        var stampNow = currentTimeStamp();
        var timeNow = currentTimeIndex();
        var expireIndex = timeIndex(this.expire);

        if (timeNow > expireIndex)
        {
            return 0;
        }
        else
        {
            var nowData = timeData(stampNow);
            var expireData = timeData(this.expire);

            var nowDate = new Date();
            var expireDate = new Date();

            nowDate.setUTCMinutes(nowData.minute);
            nowDate.setUTCHours(nowData.hour);
            nowDate.setUTCDate(nowData.day);
            nowDate.setUTCMonth(nowData.month);
            nowDate.setUTCFullYear(nowData.year);

            expireDate.setUTCMinutes(expireData.minute);
            expireDate.setUTCHours(expireData.hour);
            expireDate.setUTCDate(expireData.day);
            expireDate.setUTCMonth(expireData.month);
            expireDate.setUTCFullYear(expireData.year);

            var delta = (expireDate.getTime() - nowDate.getTime()) / 60000;

            return Math.round(delta);
        }
    }

    this.checkExpiration = function()
    {
        if (this.timeRemaining() <= 0)
        {
            if (!this.expired)
            {
                this.redraw = true;
            }

            this.expired = true;
        }
        else
        {
            if (this.expired)
            {
                this.redraw = true;
            }

            this.expired = false;
        }
    }

    this.checkActive = function()
    {
        if (this.timeSince() >= 0)
        {
            if (!this.active)
            {
                this.redraw = true;
            }

            this.active = true;
        }
        else
        {
            if (this.active)
            {
                this.redraw = true;
            }

            this.active = false;
        }
    }

    this.inEffect = function()
    {
        return (this.active && !this.expired && this.show);
    }

    this.save = function()
    {
        var outString = "";

        outString = outString + this.templateIndex + '%3a' + this.ID + '%3a' + this.name + '%3a' + this.issued + '%3a' + this.expire + '%3a' + this.category + '%3a' + saveList(this.variable, '%7c') + '%3a' + this.text + '%3a' + this.forecaster + '%3a' + this.show;

        if (this.base.geometry == GEOMETRY_CONTOURS)
        {
            outString = outString + '%3a[';

            for (var i = 0; i < this.point.length; i++)
            {
                outString = outString + this.point[i].export() + ',';
            }

            outString = outString.slice(0, outString.length-1) + ']';
        }
        else
        {
            outString = outString + '%3a' + this.point;
        }

        return outString;
    }

    this.getGeometryString = function()
    {
        var outString = '"';

        if (this.base.geometry == GEOMETRY_CONTOURS)
        {
            outString = outString + '[';

            for (var i = 0; i < this.point.length; i++)
            {
                outString = outString + this.point[i].saveString();
            }

            outString = outString + ']';
        }
        else
        {
            outString = outString + this.point;
        }

        outString = outString + '"';

        return outString;
    }

    this.getGeometryJSON = function()
    {
        var outString = '';

        if (this.base.geometry == GEOMETRY_CONTOURS)
        {
            outString = '[';

            for (var i = 0; i < this.point.length; i++)
            {
                outString = outString + this.point[i].JSON();
            }

            outString = outString.slice(0, outString.length-2) + ']';
        }
        else
        {
            outString = '{"point": [';

            for (var i = 0; i < this.point.length; i++)
            {
                outString = outString + '[' + this.point[i][0] + ', ' + this.point[i][1] + '], '
            }

            outString = outString.slice(0, outString.length-2) + ']}';
        }

        return outString;
    }

    this.getGeometryXML = function()
    {
        var outString = "";

        if (this.base.geometry == GEOMETRY_CONTOURS)
        {
            for (var i = 0; i < this.point.length; i++)
            {
                outString = outString + this.point[i].XML();
            }
        }
        else
        {
            outString = outString + '    <point>' + '\n';

            for (var i = 0; i < this.point.length; i++)
            {
                outString = outString + '      <longitude>' + this.point[i][0] + '</longitude><latitude>' + this.point[i][1] + '</latitude>' + '\n';
            }

            outString = outString + '    </point>' + '\n';
        }

        return outString.slice(0, outString.length-1);
    }

    this.getTextString = function()
    {
        var outString = "";

        for (var i = 0; i < this.text.length; i++)
        {
            if (this.text.charAt(i) == '\n')
            {
                outString = outString + "\\n";
            }
            else
            {
                outString = outString + this.text.charAt(i);
            }
        }

        return outString;
    }

    this.getVariableString = function()
    {
        if (this.variable.length == 0)
        {
            return "";
        }

        var outString = '"{'

        for (var i = 0; i < this.variable.length; i++)
        {
            outString = outString + this.base.variable[i].name + ': ' + this.variable[i] + ', ';
        }

        outString = outString.slice(0, outString.length - 2) + '}"';

        return outString;
    }

    this.getVariableJSON = function()
    {
        if (this.variable.length == 0)
        {
            return '[]';
        }

        var outString = '{';
        var lastValueIsNumber = false;

        for (var i = 0; i < this.variable.length; i++)
        {
            if (isNumeric(this.variable[i]))
            {
                outString = outString + '"' + this.base.variable[i].name + '": ' + this.variable[i] + ', ';
                lastValueIsNumber = true;
            }
            else
            {
                outString = outString + '"' + this.base.variable[i].name + '": "' + this.variable[i] + '", ';
                lastValueIsNumber = false;
            }
        }

        if (lastValueIsNumber)
        {
            outString = outString.slice(0, outString.length - 2) + '}';
        }
        else
        {
            outString = outString.slice(0, outString.length - 3) + '"}';
        }

        return outString;
    }

    this.getVariableXML = function()
    {
        if (this.variable.length == 0)
        {
            return "";
        }

        var outString = '';

        for (var i = 0; i < this.variable.length; i++)
        {
            outString = outString + '    <name>' + this.base.variable[i].name + '</name>' + '<value>' + this.variable[i] + '</value>' + '\n';
        }

        return outString.slice(0, outString.length-1);
    }

    this.URL = function(action)
    {
        var y = "";

        y = y + "?action=" + encodeURIComponent(action);
        y = y + "&name=" + encodeURIComponent(this.name);
        y = y + "&index=" + encodeURIComponent(this.templateIndex);
        y = y + "&type=" + encodeURIComponent(this.base.name);
        y = y + "&ID=" + encodeURIComponent(this.ID);
        y = y + "&category=" + encodeURIComponent(this.category);
        y = y + "&issued=" + encodeURIComponent(this.issued);
        y = y + "&expire=" + encodeURIComponent(this.expire);

        if (this.base.geometry == GEOMETRY_CONTOURS)
        {
            y = y + "&point=[";

            for (var i = 0; i < this.point.length; i++)
            {
                y = y + encodeURIComponent(this.point[i].URL());

                if (i < this.point.length - 1)
                {
                    y = y + '%2c';
                }
            }

            y = y + ']';
        }
        else
        {
            y = y + "&point=" + encodeURIComponent(this.point);
        }

        y = y + "&text=" + encodeURIComponent(this.exportText());
        y = y + "&forecaster=" + encodeURIComponent(this.forecaster);
        y = y + "&password=" + encodeURIComponent(this.password);

        y = y + "&variable=" + "[";

        for (var i = 0; i < this.variable.length; i++)
        {
            var number = isNumeric(this.variable[i]);

            if (number)
            {
                y = y + encodeURIComponent(this.variable[i]);
            }
            else
            {
                y = y + '"' + encodeURIComponent(this.variable[i]) + '"';
            }

            if (i < this.variable.length - 1)
            {
                y = y + '%2c';
            }
        }

        y = y + ']';

        for (var i = 0; i < this.variable.length; i++)
        {
            y = y + "&" + encodeURIComponent(this.base.variable[i].name) + "=";
            y = y + encodeURIComponent(this.variable[i]);
        }

        return y;
    }
}


function Layer()
{
    this.name = "";
    this.type = -1;
    this.URL = "";
    this.refresh = 0;
    this.opacity = 100;

    this.exists = true;
    this.drawn = false;
    this.show = true;
    this.object = null;
    this.timeIndex = 0;
    this.time = [];
    this.expanded = true;

    this.save = function()
    {
        var outString = "";

        outString = outString + this.name + '%00' + this.type + '%00' + this.URL + '%00' + this.refresh + '%00' + this.opacity;

        return outString;
    }
}
